<?php

namespace Orlen\OrlenPaczka\Protocol\Provider;

use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack;
use Orlen\OrlenPaczka\Label\Interfaces\PackageProvider;
use Orlen\OrlenPaczka\Protocol\Exception\PackageNoLabel;
use Orlen\OrlenPaczka\Protocol\Exception\ProtocolExist;
use Orlen\OrlenPaczka\Protocol\Exception\ProtocolExistOrNoLabel;
use Orlen\OrlenPaczka\Protocol\Interfaces\PackageProviderInterface;
use Orlen\OrlenPaczka\Protocol\Settings\GenerateProtocolSettings;
use Orlen\OrlenPaczka\Protocol\Voter\CanGenerateProtocolVoter;
use Orlen\OrlenPaczka\Repository\PackageRepository;
use Orlen\OrlenPaczka\Voter\VoteManager;

class PackagesProvider implements PackageProviderInterface
{
    private PackageRepository $packageRepository;
    private VoteManager $voteManager;

    public function __construct(PackageRepository $packageRepository, VoteManager $voteManager)
    {
        $this->packageRepository = $packageRepository;
        $this->voteManager = $voteManager;
    }
    public function getData(GenerateProtocolSettings $settings)
    {
        $idPackages = $settings->getSettings()['provider']['id_packages'];

        $packages = $this->packageRepository->findBy(['id' => $idPackages]);

        $this->_voteGenerateProtocol($packages);

        $data = [];
        foreach ($packages as $package) {
            $data[] = $package->getPackCode();
        }
        return $data;

    }

    private function _voteGenerateProtocol(array $packages)
    {
        if (empty($packages)) {
            throw new NoPackagesToGenerate('No packages to generate');
        }
//        if (!$this->voteManager->vote(CanGenerateProtocolVoter::PACKAGES_HAS_NOT_PROTOCOL, $packages)) {
//            throw new ProtocolExist('Protocol exist');
//        }
        if (!$this->voteManager->vote(CanGenerateProtocolVoter::PACKAGES_HAS_LABEL, $packages)) {
            throw new PackageNoLabel('Package no label');
        }
    }
}
