<?php

namespace Orlen\OrlenPaczka\Package\Creator;

use Orlen\OrlenPaczka\Configuration\Enum\SenderOrdersTypeEnum;
use Orlen\OrlenPaczka\Entity\Package;
use Orlen\OrlenPaczka\Entity\Shipment;
use Orlen\OrlenPaczka\Repository\PackageRepository;
use Orlen\OrlenPaczka\Repository\PackageSelectedPointRepository;
use Orlen\OrlenPaczka\Repository\SelectedPointRepository;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;

class PackageCreator
{
    private PackageRepository $packageRepository;
    private SelectedPointRepository $selectedPointRepository;
    private ShipmentRepository $shipmentRepository;
    private PackageSelectedPointRepository $packageSelectedPointRepository;

    public function __construct(
        PackageRepository $packageRepository,
        ShipmentRepository  $shipmentRepository,
        SelectedPointRepository $selectedPointRepository,
        PackageSelectedPointRepository $packageSelectedPointRepository

    )
    {
        $this->packageRepository = $packageRepository;
        $this->selectedPointRepository = $selectedPointRepository;
        $this->shipmentRepository = $shipmentRepository;
        $this->packageSelectedPointRepository = $packageSelectedPointRepository;
    }
    public function create(\Order $order)
    {
        $carrier = new \Carrier($order->id_carrier);
        $shipment = $this->shipmentRepository->findOneBy(['carrier' => $carrier->id_reference]);
        $pickup = $this->selectedPointRepository->findOneBy(['carrier' => $order->id_carrier, 'cart' => $order->id_cart]);
        $package = new Package();
        $package->setIdOrder($order->id);
        $package->setPickup($this->packageSelectedPointRepository->createPackageSelectedPointFromSelectedPoint($pickup));
        $package->setShipment($shipment);
        $package->setSize($shipment->getSize());
        $package->setSenderOrders(null);
        return $this->packageRepository->add($package);
    }

    public function createWithEmptyPickup(\Order $order)
    {
        $carrier = new \Carrier($order->id_carrier);
        $shipment = $this->shipmentRepository->findOneBy(['carrier' => $carrier->id_reference]);
        if (empty($shipment)){
            return false;
        }
        $package = new Package();
        $package->setIdOrder($order->id);
        $package->setPickup(null);
        $package->setShipment($shipment);
        $package->setSize($shipment->getSize());
        $package->setSenderOrders(null);
        $this->packageRepository->add($package);
        return true;
    }


}
