<?php

namespace Orlen\OrlenPaczka\Logger\Factory;

use Monolog\Logger;
use Orlen\OrlenPaczka\Logger\Driver\Interfaces\LoggerDriverInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class LoggerFactory
{
    /** @var LoggerDriverInterface[] */
    private  $loggerDrivers;
    private array $loggers = [];
    private ?LoggerDriverInterface $loggerDriver;

    public function __construct($loggerDrivers)
    {
        $this->loggerDrivers = $loggerDrivers;
    }

    public function getLogger(string $driver,string $channel, array $options = []): LoggerInterface
    {
        $this->loggerDriver = null;
        foreach ($this->loggerDrivers as $loggerDriver) {
            if ($loggerDriver->getName() === $driver) {
                $this->loggerDriver = $loggerDriver;
                $resolvedOptions = $this->_configureOptions($options);
                return $this->loggers[$this->getKey($channel, $resolvedOptions)] ?? $this->_createLogger($channel, $resolvedOptions);
            }
        }
        throw new \Exception('Logger driver not found');
    }

    private function _createLogger(string $channel, array $options): LoggerInterface
    {
        $logger = new Logger($channel);
        $this->loggerDriver->setHandler($logger, $options);
        $this->loggerDriver->setProcessor($logger, $options);
        $this->loggers[$this->getKey($channel, $options)] = $logger;
        return $logger;
    }

    private function getKey(string $channel, array $options = [])
    {
        $baseKey = $this->loggerDriver->getName() . '_' . $channel;

        if (empty($options)) {
            return $baseKey;
        }

        // Sort options by keys to ensure consistent hash generation
        ksort($options);
        $optionsHash = md5(json_encode($options));

        return $baseKey . '_' . $optionsHash;
    }

    private function _configureOptions(array $options)
    {
        $optionsResolver = new OptionsResolver();
        $this->loggerDriver->configureOptions($optionsResolver);
        return $optionsResolver->resolve($options);
    }


}
