<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Form\Provider\FormatLabelProvider;
use Orlen\OrlenPaczka\Form\Type\GenerateLabelType;
use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use Orlen\OrlenPaczka\Label\Settings\GenerateLabelSettings;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\AjaxBulkAction;
use Symfony\Component\Form\FormFactory;
use Symfony\Component\Form\FormFactoryInterface;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;
use Twig\Environment;

class DisplayAdminGridTableBefore implements HookInterface
{
    private  $translator;
    private Environment $twig;
    private FormFactory $formFactory;
    private FormatLabelProvider $formatLabelProvider;

    public function __construct( $translator, Environment $twig, FormFactoryInterface $formFactory, FormatLabelProvider $formatLabelProvider)
    {
        $this->translator = $translator;
        $this->twig = $twig;
        $this->formFactory = $formFactory;
        $this->formatLabelProvider = $formatLabelProvider;
    }
    public function execute($params)
    {
        if ($params['legacy_controller'] !== 'AdminOrders') {
            return '';
        }

        $form = $this->formFactory->create(GenerateLabelType::class, $this->formatLabelProvider->getFormatLabelArray(), [
            'url_action' => 'orlenpaczka.order.generate_label_list']);

        return $this->twig->render('@Modules/orlenpaczka/views/templates/admin/order/genetrate-label-popup-list.html.twig', ['form' => $form->createView()]);


    }

}
