<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Carrier\Exception\CarrierNotActiveException;
use Orlen\OrlenPaczka\Carrier\Exception\NotSelectedPointForCarrierException;
use Orlen\OrlenPaczka\Carrier\Exception\PhoneIsMissingException;
use Orlen\OrlenPaczka\Carrier\Voter\CarrierCompletedVoter;
use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use Orlen\OrlenPaczka\Voter\VoteManager;

class ActionValidateStepComplete implements HookInterface
{
    private VoteManager $voteManager;
    private \Context $context;
    private $translator;

    public function __construct(
        VoteManager $voteManager,
        \Context $context,
        $translator
    )
    {
        $this->voteManager = $voteManager;
        $this->context = $context;
        $this->translator = $translator;
    }
    public function execute($params)
    {
        try{
            $params['completed'] = $this->voteManager->vote(CarrierCompletedVoter::CARRIER_COMPLETE_VOTER, $params['cart']);
        }catch (CarrierNotActiveException $e) {
            $params['completed'] = false;
            $this->context->controller->errors =
                array_merge($this->context->controller->errors, array_values([$this->translator->trans('Carrier is not active', [], 'Modules.Orlenpaczka.Carrier')]));
        }catch (NotSelectedPointForCarrierException $e) {
            $params['completed'] = false;
            $this->context->controller->errors =
                array_merge($this->context->controller->errors, array_values([$this->translator->trans('Not selected point', [], 'Modules.Orlenpaczka.Carrier')]));
        }catch (PhoneIsMissingException $e) {
            $params['completed'] = false;
            $this->context->controller->errors =
                array_merge($this->context->controller->errors, array_values([$this->translator->trans('Phone is required', [], 'Modules.Orlenpaczka.Carrier')]));
        }


    }

}
