<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Carrier\Voter\CarrierIsModuleVoter;
use Orlen\OrlenPaczka\Entity\Package;
use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use Orlen\OrlenPaczka\Package\Creator\PackageCreator;
use Orlen\OrlenPaczka\Voter\VoteManager;

class ActionValidateOrder implements HookInterface
{
    private VoteManager $voteManager;
    private PackageCreator $packageCreator;

    public function __construct(VoteManager $voteManager, PackageCreator $packageCreator)
    {
        $this->voteManager = $voteManager;
        $this->packageCreator = $packageCreator;
    }

    public function execute($params)
    {
        $order = $params['order'];
        $carrier = new \Carrier($order->id_carrier);
        if ($this->voteManager->vote(CarrierIsModuleVoter::CARRIER_IS_MODULE_VOTER, $carrier)) {
            $this->packageCreator->create($order);
        }

    }
}
