<?php

namespace Orlen\OrlenPaczka\Grid\Definition\Factory;

use Orlen\OrlenPaczka\Form\Type\OrlenDateRangeType;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\BulkActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\ModalFormSubmitBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\SubmitBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Type\SimpleGridAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\BooleanColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\BulkActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DateTimeColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\IdentifierColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\PositionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractFilterableGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Grid\Filter\Filter;
use PrestaShop\PrestaShop\Core\Grid\Filter\FilterCollection;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use PrestaShopBundle\Event\Dispatcher\NullDispatcher;
use PrestaShopBundle\Form\Admin\Type\DateRangeType;
use PrestaShopBundle\Form\Admin\Type\SearchAndResetType;
use PrestaShopBundle\Form\Admin\Type\YesAndNoChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class ProtocolGridDefinitionFactory extends AbstractFilterableGridDefinitionFactory
{
    public const GRID_ID = 'orlenpaczka_protocol';

    public function __construct(
        Translator $translator,
        HookDispatcherInterface $hookDispatcher = null
    ) {
        parent::__construct($hookDispatcher ?? new NullDispatcher());
        $this->setTranslator($translator);
    }

    protected function getId(): string
    {
        return self::GRID_ID;
    }

    protected function getName(): string
    {
        return $this->trans('Protocols', [], 'Modules.Orlenpaczka.Admin');
    }

    protected function getColumns(): ColumnCollection
    {
        return (new ColumnCollection())
//            ->add(
//                (new BulkActionColumn('package_bulk'))
//                    ->setOptions([
//                        'bulk_field' => 'id_protocol',
//                    ])
//            )
            ->add(
                (new IdentifierColumn('id_protocol'))
                    ->setName($this->trans('ID', [], 'Admin.Global'))
                    ->setOptions([
                        'identifier_field' => 'id_protocol',
                    ])
            )
            ->add(
                (new DataColumn('protocol_code'))
                    ->setName($this->trans('Code', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'protocol_code',
                    ])
            )
            ->add(
                (new DataColumn('status'))
                    ->setName($this->trans('Status', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'status',
                    ])
            )
            ->add(
                (new DataColumn('label_date_generated'))
                    ->setName($this->trans('Label date create', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'label_date_generated',
                    ])
            )
            ->add(
                (new DataColumn('packages'))
                    ->setName($this->trans('Packages', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'packages',
                    ])
            )
            ->add(
                (new ActionColumn('actions'))
                    ->setName($this->trans('Actions', [], 'Admin.Global'))
                    ->setOptions([
                        'actions' => $this->getRowActions(),
                    ])
            );
    }

    protected function getFilters()
    {
        return (new FilterCollection())
            ->add(
                (new Filter('id_protocol', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search id', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_protocol')
            )
            ->add(
                (new Filter('protocol_code', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search code', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('protocol_code')
            )
            ->add(
                (new Filter('status', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search status', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('status')
            )
            ->add(
                (new Filter('label_date_generated', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search label generate', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('label_date_generated')
            )
            ->add(
                (new Filter('packages', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search package', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('packages')
            )
            ->add(
                (new Filter('actions', SearchAndResetType::class))
                    ->setTypeOptions([
                        'reset_route' => 'admin_common_reset_search_by_filter_id',
                        'reset_route_params' => [
                            'filterId' => self::GRID_ID,
                        ],
                        'redirect_route' => 'orlenpaczka.config.protocol.index',
                    ])
                    ->setAssociatedColumn('actions')
            );
    }

    protected function getGridActions()
    {
        return (new GridActionCollection())
            ->add(
                (new SimpleGridAction('common_refresh_list'))
                    ->setName($this->trans('Refresh list', [], 'Admin.Advparameters.Feature'))
                    ->setIcon('refresh')
            )
            ->add(
                (new SimpleGridAction('common_show_query'))
                    ->setName($this->trans('Show SQL query', [], 'Admin.Actions'))
                    ->setIcon('code')
            )
            ->add(
                (new SimpleGridAction('common_export_sql_manager'))
                    ->setName($this->trans('Export to SQL Manager', [], 'Admin.Actions'))
                    ->setIcon('storage')
            );
    }

    private function getRowActions()
    {
        return (new RowActionCollection())
            ->add(
                (new LinkRowAction('download'))
                    ->setName($this->trans('Download label', [], 'Admin.Actions'))
                    ->setOptions([
                        'route' => 'orlenpaczka.config.protocol.download_label',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id_protocol',
                    ])
                    ->setIcon('download')
            );
    }

    protected function getBulkActions()
    {
        return (new BulkActionCollection());
//            ->add((new ModalFormSubmitBulkAction('call_pickup'))
//                ->setName($this->trans('Generate protocol', [], 'Admin.Orderscustomers.Feature'))
//                ->setOptions([
//                    'submit_route' => 'orlenpaczka.call_pickup',
//                    'modal_id' => 'callPickupModal',
//                ])
//            );



    }
}
