<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Form\Type;

use Orlen\OrlenPaczka\Choice\Translator\ChoiceTranslator;
use Orlen\OrlenPaczka\Configuration\Enum\FormatEnum;
use Orlen\OrlenPaczka\Configuration\Enum\ShipmentSizeEnum;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TelType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class GenerateLabelOrderType extends AbstractType
{
    private Translator $translator;
    private RouterInterface $router;
    private ChoiceTranslator $choiceTranslator;

    public function __construct(Translator $translator, RouterInterface $router, ChoiceTranslator $choiceTranslator)
    {
        $this->translator = $translator;
        $this->router = $router;
        $this->choiceTranslator = $choiceTranslator;
    }
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        // Pobieramy id_package z opcji formularza
        $idPackage = $options['id_package'];

        $builder
            ->setAction($this->router->generate('orlenpaczka.order.generate_label', ['id' => $idPackage]))
            ->add('id_order', HiddenType::class, [
            ])
            ->add('format', ChoiceType::class, [
                'label' => $this->translator->trans('Format Label', [], 'Modules.Orlenpaczka.Form'),
                'choices' => FormatEnum::toArray()
            ])
            ->add('EMail', EmailType::class, [
                'label' => $this->translator->trans('Email', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('FirstName', TextType::class, [
                'label' => $this->translator->trans('First Name', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('LastName', TextType::class, [
                'label' => $this->translator->trans('Last Name', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('CompanyName', TextType::class, [
                'label' => $this->translator->trans('Company Name', [], 'Modules.Orlenpaczka.Form'),
                'required' => false,
            ])
            ->add('PhoneNumber', TelType::class, [
                'label' => $this->translator->trans('Phone Number', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('City', TextType::class, [
                'label' => $this->translator->trans('City', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('PostCode', TextType::class, [
                'label' => $this->translator->trans('Post Code', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('BoxSize', ChoiceType::class, [
                'label' => $this->translator->trans('Box Size', [], 'Modules.Orlenpaczka.Form'),
                'choices' => ShipmentSizeEnum::toArray(),
                'required' => true,
            ])
            ->add('DestinationPoint', TextType::class, [
                'label' => $this->translator->trans('Destination Point Code', [], 'Modules.Orlenpaczka.Order'),
                'required' => false,
                'attr' => [
                    'class' => 'js_destination-code',
                    'readonly' => 'readonly'
                ]
            ]);

        // Dodajemy pole SenderOrders tylko gdy sender_orders_type jest równe 0
        if ($options['sender_orders_type'] === 0) {
            $builder->add('SenderOrders', TextType::class, [
                'label' => $this->translator->trans('Sender Orders', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
                'data' => $options['sender_orders'], // Ustawiamy domyślną wartość z opcji
            ]);
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null,
            'sender_orders_type' => null, // Typ zamówienia nadawcy
            'sender_orders' => null,      // Domyślna wartość dla pola SenderOrders
            'id_package' => null,         // ID paczki do użycia w URL
        ]);
    }
}
