<?php

namespace Orlen\OrlenPaczka\Form\Provider;

use Doctrine\ORM\EntityManagerInterface;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Entity\Shipment;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class ShipmentCarrierProvider
{
    private EntityManagerInterface $entityManager;
    private Translator $translator;

    public function __construct(EntityManagerInterface $entityManager, Translator  $translator)
    {
        $this->entityManager = $entityManager;
        $this->translator = $translator;
    }
    public function getCarriers($currentShipment = null)
    {
        $connection =$this->entityManager->getConnection();
        $qb = $connection->createQueryBuilder()
            ->select('c.id_reference, c.name')
            ->from(_DB_PREFIX_.'carrier', 'c')
            ->where('c.active = 1')
            ->andWhere('c.deleted = 0')
            ->andWhere('c.is_module = 1')
            ->andWhere('c.external_module_name LIKE :moduleName')
            ->setParameter('moduleName', ConfigurationModule::MODULE_NAME);

        $usedCarriers = $connection->createQueryBuilder()
            ->select('s.id_carrier_reference')
            ->from(Shipment::TABLE_NAME, 's')
            ->where('s.id_carrier_reference IS NOT NULL');

        if ($currentShipment) {
            $usedCarriers->andWhere('s.id_shipment != :currentId');
            $qb->andwhere(
                'c.id_reference NOT IN (' . $usedCarriers->getSQL() . ')',
            )
                ->setParameter('currentId', $currentShipment);
        }else{
            $qb->andwhere($qb->expr()->notIn('c.id_reference', $usedCarriers->getSQL()));
        }
        $qb->orderBy('c.name', 'ASC');

        $result = $qb->execute()->fetchAll();
        $carriers = [$this->translator->trans('Create Carrier', [], 'Modules.Orlenpaczka.Tab') => ConfigurationModule::CREATE_CARRIER]; ;



        foreach ($result as $row) {
            $carriers[$row['name']] = $row['id_reference'];
        }
        return $carriers;

//        $cariers = $this->entityManager->createQueryBuilder()
//            ->select('c.id_reference, c.name')
//            ->from(_DB_PREFIX_.'carrier', 'c')
//            ->where('c.active = 1 AND c.deleted = 0');
    }
}
