<?php

namespace Orlen\OrlenPaczka\Form\Provider;

use Orlen\OrlenPaczka\Authorization\Dto\CredentialsInterface;
use Orlen\OrlenPaczka\Authorization\Provider\CredentialsProvider;
use Orlen\OrlenPaczka\Authorization\Provider\CredentialsProviderInterface;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Form\Dto\Authorization;

class AuthorizationProvider
{
    private CredentialsProviderInterface $credentialsProvider;

    public function __construct(CredentialsProviderInterface $credentialsProvider)
    {
        $this->credentialsProvider = $credentialsProvider;
    }
    public function getData():Authorization
    {
        $sandbox = (bool)\Configuration::get(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_SANDBOX_MODE, null, null, null, true);
        $credentials = $this->credentialsProvider->getCredentials($sandbox);
        $authorization = new Authorization();
        $authorization->setSandbox($sandbox);
        $authorization->setToken(\Configuration::get(ConfigurationModule::ORLEN_PACZKA_MAP_WIDGET_TOKEN, null, null, null, ''));
        if ($credentials instanceof CredentialsInterface) {
            $authorization->setPartnerId($credentials->getPartnerId());
            $authorization->setPartnerKey($credentials->getPartnerKey());
        }
        return $authorization;
    }
}
