<?php

namespace Orlen\OrlenPaczka\Form\Handler;

use Doctrine\ORM\EntityManagerInterface;
use Orlen\OrlenPaczka\Carrier\Creator\CarrierCreator;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Entity\Shipment;

class ShipmentHandler
{
    private EntityManagerInterface $entityManager;
    private CarrierCreator $carrierCreator;

    public function __construct(
        EntityManagerInterface $entityManager,
        CarrierCreator $carrierCreator
    )
    {
        $this->entityManager = $entityManager;
        $this->carrierCreator = $carrierCreator;
    }
    public function handle(Shipment $shipment)
    {
        if ($shipment->getCarrier() == ConfigurationModule::CREATE_CARRIER) {
            $idCarrier = $this->carrierCreator->create();
            $carrier = new \Carrier($idCarrier);
            $shipment->setCarrier($carrier->id_reference);
        }
        $this->entityManager->persist($shipment);
        return $this->entityManager->flush();
    }
}
