<?php

namespace Orlen\OrlenPaczka\Form\Handler;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Form\Dto\Authorization;

class AuthorizationHandler
{
    public function handle(Authorization $authorization)
    {
        \Configuration::updateValue(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_SANDBOX_MODE, (bool)$authorization->getSandbox());
        \Configuration::updateValue(ConfigurationModule::ORLEN_PACZKA_MAP_WIDGET_TOKEN, (string) $authorization->getToken());
        $authorization->getSandbox()? $this->updateSandbox($authorization): $this->updateProd($authorization);
    }

    private function updateSandbox(Authorization $authorization)
    {
        \Configuration::updateValue(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_ID_SANDBOX, $authorization->getPartnerId());
        \Configuration::updateValue(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_KEY_SANDBOX, $authorization->getPartnerKey());
    }

    private function updateProd(Authorization $authorization)
    {
        \Configuration::updateValue(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_ID_PROD, $authorization->getPartnerId());
        \Configuration::updateValue(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_KEY_PROD, $authorization->getPartnerKey());
    }
}
