<?php

namespace Orlen\OrlenPaczka\Entity;

use Orlen\OrlenPaczka\Repository\ShipmentRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=ShipmentRepository::class)
 * @ORM\Table(name=Shipment::TABLE_NAME)
 */
class Shipment
{

    public const TABLE_NAME = _DB_PREFIX_ . 'orlenpaczka_shipment';
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer", name="id_shipment")
     */
    private $id;

    /**
     * @ORM\OneToOne(targetEntity=ShipmentType::class, inversedBy="shipment", cascade={"persist"})
     * @ORM\JoinColumn(nullable=false, name="id_shipment_type", referencedColumnName="id_shipment_type")
     */
    private $shipmentType;

    /**
     * @ORM\Column(type="integer", name="id_carrier_reference")
     */
    private $carrier;

    /**
     * @ORM\Column(type="boolean", name="carrier_active")
     */
    private $carrierActive = false;

    /**
     * @ORM\Column(type="boolean", name="map_active")
     */
    private $mapActive = false;

    /**
     * @ORM\Column(type="string", length=5)
     */
    private $size;

    /**
     * @ORM\Column(type="string", length=15, name="label_format")
     */
    private $labelFormat;


    /**
     * @ORM\Column(type="string", length=30, nullable=true, name="sender_orders")
     */
    private $senderOrders;

    /**
     * @ORM\Column(type="smallint", name="sender_orders_type")
     */
    private $senderOrdersType;



    public function getId(): ?int
    {
        return $this->id;
    }

    public function getShipmentType(): ?ShipmentType
    {
        return $this->shipmentType;
    }

    public function setShipmentType(ShipmentType $shipmentType): self
    {
        $this->shipmentType = $shipmentType;

        return $this;
    }

    public function getCarrier(): ?int
    {
        return $this->carrier;
    }

    public function setCarrier(int $carrier): self
    {
        $this->carrier = $carrier;

        return $this;
    }

    public function getCarrierActive(): ?int
    {
        return $this->carrierActive;
    }

    public function setCarrierActive(bool $carrierActive): self
    {
        $this->carrierActive = $carrierActive;

        return $this;
    }

    public function getMapActive(): ?bool
    {
        return $this->mapActive;
    }

    public function setMapActive(bool $mapActive): self
    {
        $this->mapActive = $mapActive;

        return $this;
    }

    public function getSize(): ?string
    {
        return $this->size;
    }

    public function setSize(string $size): self
    {
        $this->size = $size;

        return $this;
    }


    public function getSenderOrders(): ?string
    {
        return $this->senderOrders;
    }

    public function setSenderOrders(?string $senderOrders): self
    {
        $this->senderOrders = $senderOrders;

        return $this;
    }

    public function getSenderOrdersType(): ?int
    {
        return $this->senderOrdersType;
    }

    public function setSenderOrdersType(int $senderOrdersType): self
    {
        $this->senderOrdersType = $senderOrdersType;

        return $this;
    }

    public function getLabelFormat(): ?string
    {
        return $this->labelFormat;
    }

    public function setLabelFormat(string $labelFormat): self
    {
        $this->labelFormat = $labelFormat;

        return $this;
    }

}
