<?php

namespace Orlen\OrlenPaczka\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Orlen\OrlenPaczka\Repository\ProtocolRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=ProtocolRepository::class)
 * @ORM\Table(name=Protocol::TABLE_NAME)
 */
class Protocol
{
    public const TABLE_NAME = _DB_PREFIX_ . 'orlenpaczka_protocol';
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer", name="id_protocol")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, name="protocol_code")
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=255, nullable=true, name="label_name")
     */
    private $labelName;

    /**
     * @ORM\Column(type="datetime", name="label_date_generated", nullable=true)
     */
    private $labelDateGenerated;

    /**
     * @ORM\OneToMany(targetEntity=Package::class, mappedBy="protocol")
     */
    private $packages;

    /**
     * @ORM\ManyToOne(targetEntity=Delivery::class, inversedBy="protocols")
     * @ORM\JoinColumn(nullable=true, name="id_delivery", referencedColumnName="id_delivery")
     */
    private $delivery;

    public function __construct()
    {
        $this->packages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection<int, Package>
     */
    public function getPackages(): Collection
    {
        return $this->packages;
    }

    public function addPackage(Package $package): self
    {
        if (!$this->packages->contains($package)) {
            $this->packages[] = $package;
            $package->setProtocol($this);
        }

        return $this;
    }

    public function removePackage(Package $package): self
    {
        if ($this->packages->removeElement($package)) {
            // set the owning side to null (unless already changed)
            if ($package->getProtocol() === $this) {
                $package->setProtocol(null);
            }
        }

        return $this;
    }

    public function getLabelName(): ?string
    {
        return $this->labelName;
    }

    public function setLabelName(?string $labelName): self
    {
        $this->labelName = $labelName;

        return $this;
    }

    public function getLabelDateGenerated(): ?\DateTimeInterface
    {
        return $this->labelDateGenerated;
    }

    public function setLabelDateGenerated(?\DateTimeInterface $labelDateGenerated): self
    {
        $this->labelDateGenerated = $labelDateGenerated;

        return $this;
    }

    public function getDelivery(): ?Delivery
    {
        return $this->delivery;
    }

    public function setDelivery(?Delivery $delivery): self
    {
        $this->delivery = $delivery;

        return $this;
    }

    public function removePackages()
    {
        foreach ($this->getPackages() as $package) {
            $package->setProtocol(null);
        }
        $this->packages->clear();;
    }
}
