<?php

namespace Orlen\OrlenPaczka\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Orlen\OrlenPaczka\Repository\DeliveryRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DeliveryRepository::class)
 * @ORM\Table(name=Delivery::TABLE_NAME)
 */
class Delivery
{
    public const TABLE_NAME = _DB_PREFIX_ . 'orlenpaczka_delivery';
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer", name="id_delivery")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $code;

    /**
     * @ORM\OneToMany(targetEntity=Protocol::class, mappedBy="delivery")
     */
    private $protocols;

    /**
     * @ORM\OneToMany(targetEntity=Package::class, mappedBy="delivery")
     */
    private $packages;

    /**
     * @ORM\Column(type="date", name="date_pickup")
     */
    private $datePickup;

    /**
     * @ORM\Column(type="time", name="hour_pickup_from")
     */
    private $hourPickupFrom;

    /**
     * @ORM\Column(type="time", name="hour_pickup_to")
     */
    private $hourPickupTo;

    /**
     * @ORM\Column(type="datetime", name="date_add", nullable=false, options={"default": "CURRENT_TIMESTAMP"})
     */
    private $dateAdd;

    public function __construct()
    {
        $this->dateAdd = new \DateTime();
        $this->protocols = new ArrayCollection();
        $this->packages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return Collection<int, Protocol>
     */
    public function getProtocols(): Collection
    {
        return $this->protocols;
    }

    public function addProtocol(Protocol $protocol): self
    {
        if (!$this->protocols->contains($protocol)) {
            $this->protocols[] = $protocol;
            $protocol->setDelivery($this);
            foreach ($protocol->getPackages() as $package) {
                $this->addPackage($package);
            }
        }

        return $this;
    }

    public function removeProtocol(Protocol $protocol): self
    {
        if ($this->protocols->removeElement($protocol)) {
            // set the owning side to null (unless already changed)
            if ($protocol->getDelivery() === $this) {
                $protocol->setDelivery(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Package>
     */
    public function getPackages(): Collection
    {
        return $this->packages;
    }

    public function addPackage(Package $package): self
    {
        if (!$this->packages->contains($package)) {
            $this->packages[] = $package;
            $package->setDelivery($this);
        }

        return $this;
    }

    public function removePackage(Package $package): self
    {
        if ($this->packages->removeElement($package)) {
            // set the owning side to null (unless already changed)
            if ($package->getDelivery() === $this) {
                $package->setDelivery(null);
            }
        }

        return $this;
    }

    public function getDatePickup(): ?\DateTimeInterface
    {
        return $this->datePickup;
    }

    public function setDatePickup(\DateTimeInterface $datePickup): self
    {
        $this->datePickup = $datePickup;

        return $this;
    }

    public function getHourPickupFrom(): ?\DateTimeInterface
    {
        return $this->hourPickupFrom;
    }

    public function setHourPickupFrom(\DateTimeInterface $hourPickupFrom): self
    {
        $this->hourPickupFrom = $hourPickupFrom;

        return $this;
    }

    public function getHourPickupTo(): ?\DateTimeInterface
    {
        return $this->hourPickupTo;
    }

    public function setHourPickupTo(\DateTimeInterface $hourPickupTo): self
    {
        $this->hourPickupTo = $hourPickupTo;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getDateAdd()
    {
        if (!isset($this->dateAdd)) {
            $this->dateAdd = new \DateTime();
        }
        return $this->dateAdd;
    }

    /**
     * @param mixed $dateAdd
     */
    public function setDateAdd(\DateTimeInterface$dateAdd): self
    {
        $this->dateAdd = $dateAdd;

        return $this;
    }


}
