<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Controller\Admin;

use Orlen\OrlenPaczka\Api\OrlenPaczka\OrlenPaczkaClientFactory;
use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetAvailablePickups;
use Orlen\OrlenPaczka\CallPickup\Provider\PickupDateProvider;
use Orlen\OrlenPaczka\CallPickup\Provider\PickupHoursProvider;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Form\Handler\CallPickupHandler;
use Orlen\OrlenPaczka\Form\Type\CallPickupType;
use Orlen\OrlenPaczka\Form\Type\GenerateLabelType;
use Orlen\OrlenPaczka\Repository\ProtocolRepository;
use Orlen\OrlenPaczka\Search\Filters\ProtocolFilters;
use Orlen\OrlenPaczka\Tabs\Tab\ShippingHistoryTab;
use Orlen\OrlenPaczka\Tabs\Tabs;
use PrestaShop\PrestaShop\Core\Grid\Presenter\GridPresenterInterface;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;
use Symfony\Component\HttpFoundation\Request;

/**
 * @Route(path="/config", name="orlenpaczka.config.protocol")
 */
class ProtocolController extends FrameworkBundleAdminController
{

    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @Route("/protocol", name=".index", methods={"GET"})
     */
    public function protocolGridAction(
        \Module $module,
        Tabs $tabs,
        GridPresenterInterface $gridPresenter,
        ProtocolFilters $filters,
        ShippingHistoryTab $shippingHistoryTab,
        $gridFactoryProtocol
    )
    {
        $shippingHistoryTab->setActive();
        $grid = $gridPresenter->present($gridFactoryProtocol->getGrid($filters));

        $form = $this->createForm(CallPickupType::class);


        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/protocol_grid.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'grid' => $grid,
            'form' => $form->createView(),
            'title' => $this->translator->trans('Shipment', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
    /**
     * @Route("/protocol/download_label/{id}", name=".download_label",  methods={"GET"})
     */

    public function downloadProtocolLabelAction($id, ProtocolRepository $protocolRepository)
    {
        $protocol = $protocolRepository->find($id);
        $path = ConfigurationModule::PROTOCOL_PATH.DIRECTORY_SEPARATOR. $protocol->getLabelName();

        if (file_exists($path)) {
            $response = new \Symfony\Component\HttpFoundation\BinaryFileResponse($path);
            $response->setContentDisposition(
                \Symfony\Component\HttpFoundation\ResponseHeaderBag::DISPOSITION_ATTACHMENT,
                $protocol->getLabelName()
            );
            return $response;
        }
        return $this->redirectToRoute('orlenpaczka.config.protocol.index');
    }





}
