<?php

namespace Orlen\OrlenPaczka\Controller\Admin;

use Orlen\OrlenPaczka\Search\Filters\PackageFilters;
use Orlen\OrlenPaczka\Tabs\Tab\LogsTab;
use Orlen\OrlenPaczka\Tabs\Tabs;
use PrestaShop\PrestaShop\Core\Grid\Presenter\GridPresenterInterface;
use Orlen\OrlenPaczka\Search\Filters\LogFilters;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\Routing\Annotation\Route;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

/**
 * @Route(path="/config", name="orlenpaczka.config.logs")
 */
class LogsController extends FrameworkBundleAdminController
{
    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }
    /**
     * @Route("/logs", name=".index", methods={"GET"})
     */
    public function logsGridAction(
        \Module $module,
        Tabs $tabs,
        GridPresenterInterface $gridPresenter,
        LogFilters $filters,
        LogsTab $logsTab,
        $gridFactoryLogs
    )
    {
        $logsTab->setActive();
        $grid = $gridPresenter->present($gridFactoryLogs->getGrid($filters));



        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/logs.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'grid' => $grid,
            'title' => $this->translator->trans('Logs', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
}
