<?php

namespace Orlen\OrlenPaczka\Controller\Admin;

use Orlen\OrlenPaczka\Search\Filters\LogFilters;
use Orlen\OrlenPaczka\Tabs\Tab\HelpTab;
use Orlen\OrlenPaczka\Tabs\Tab\LogsTab;
use Orlen\OrlenPaczka\Tabs\Tabs;
use PrestaShop\PrestaShop\Core\Grid\Presenter\GridPresenterInterface;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\Routing\Annotation\Route;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;


/**
 * @Route(path="/config", name="orlenpaczka.config.help")
 */
class HelpController extends FrameworkBundleAdminController
{
    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }
    /**
     * @Route("/help", name=".index", methods={"GET"})
     */
    public function indexAction(
        \Module $module,
        Tabs $tabs,
        HelpTab $helpTab
    )
    {
        $helpTab->setActive();
        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/help.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'title' => $this->translator->trans('Help', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
}
