<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Controller\Admin;

use Doctrine\ORM\EntityManagerInterface;
use Orlen\OrlenPaczka\Entity\Address;
use Orlen\OrlenPaczka\Form\Type\AddressType;
use Orlen\OrlenPaczka\Tabs\Tab\AddressTab;
use Orlen\OrlenPaczka\Tabs\Tabs;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

/**
 * @Route(path="/config", name="orlenpaczka.config.address")
 */
class AddressController extends FrameworkBundleAdminController
{
    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @Route("/address", name=".index", methods={"GET", "POST"})
     */
    public function addressAction(
        \Module $module,
        Request $request,
        Tabs $tabs,
        EntityManagerInterface $entityManager,
        AddressTab $addressTab
    ): Response
    {
        $addressTab->setActive();
        $entity = $entityManager->getRepository(Address::class)->find(1);
        if (!$entity){
            $entity = new Address();
        }

        $form = $this->createForm(AddressType::class, $entity);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($form->getData());
            $entityManager->flush();
        }

        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/address.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'form' => $form->createView(),
            'title' => $this->translator->trans('Address', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
}
