<?php

namespace Orlen\OrlenPaczka\Configuration;

use Monolog\Logger;
use Orlen\OrlenPaczka\Configuration\Enum\LoggerStoreEnum;

class ConfigurationModule
{

    public const MODULE_NAME = 'orlenpaczka';
    public const LOGO_PATH = _PS_MODULE_DIR_ . self::MODULE_NAME . DIRECTORY_SEPARATOR . 'img' . DIRECTORY_SEPARATOR. 'logo'. DIRECTORY_SEPARATOR. 'orlenpaczka_logo.png';

    public const CONFIG_PATH = _PS_MODULE_DIR_ . self::MODULE_NAME . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR;
    public const DATABASE_YML_FILE = self::CONFIG_PATH . DIRECTORY_SEPARATOR . 'database.yml';
    public const HOOKS_YML_FILE = self::CONFIG_PATH . DIRECTORY_SEPARATOR . 'hooks.yml';
    public const ORLEN_PACZKA_WSDL_PROD = 'https://api.orlenpaczka.pl/WebServicePwRProd/WebServicePwR.asmx?wsdl';
    public const ORLEN_PACZKA_WSDL_SANDBOX = 'https://api-test.orlenpaczka.pl/WebServicePwR/WebServicePwR.asmx?WSDL';
    public const CONFIG_KEY_ORLEN_PACZKA_SANDBOX_MODE = 'ORLEN_PACZKA_SANDBOX_MODE';
    public const ORLEN_PACZKA_MAP_WIDGET_TOKEN = 'ORLEN_PACZKA_MAP_WIDGET_TOKEN';
    public const ORLEN_PACZKA_MAP_WIDGET_API = 'https://mapa.orlenpaczka.pl/';

    public const CONFIG_KEY_ORLEN_PACZKA_PARTNER_KEY_PROD = 'ORLEN_PACZKA_PARTNER_KEY_PROD';
    public const CONFIG_KEY_ORLEN_PACZKA_PARTNER_KEY_SANDBOX = 'ORLEN_PACZKA_PARTNER_KEY_SANDBOX';
    public const CONFIG_KEY_ORLEN_PACZKA_PARTNER_ID_PROD = 'ORLEN_PACZKA_PARTNER_ID_PROD';
    public const CONFIG_KEY_ORLEN_PACZKA_PARTNER_ID_SANDBOX = 'ORLEN_PACZKA_PARTNER_ID_SANDBOX';
    public const LOG_PATH = _PS_MODULE_DIR_ . self::MODULE_NAME . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR;
    public const LOG_LEVEL = Logger::ERROR;
    public const LOG_INTROSPECTION_LEVEL = Logger::ERROR;
    public const LOG_MAX_FILE = 10;

    public const CREATE_CARRIER = 0;

    public const LABEL_PATH = _PS_MODULE_DIR_ . 'orlenpaczka'.DIRECTORY_SEPARATOR.'labels'.DIRECTORY_SEPARATOR;
    public const PROTOCOL_PATH = _PS_MODULE_DIR_ . 'orlenpaczka'.DIRECTORY_SEPARATOR.'protocols'.DIRECTORY_SEPARATOR;

    public const LOG_STORE = [
        LoggerStoreEnum::FILE,
        LoggerStoreEnum::DATABASE,
    ];

    public const PLATFORM = 'PRESTASHOP_'._PS_VERSION_;


    public static function getWsdl(bool $sandbox)
    {
        return $sandbox? self::ORLEN_PACZKA_WSDL_SANDBOX : self::ORLEN_PACZKA_WSDL_PROD;
    }


}
