<?php

namespace Orlen\OrlenPaczka\Carrier\Voter;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;
use Orlen\OrlenPaczka\Voter\Interfaces\VoterInterface;

class CarrierIsModuleVoter implements VoterInterface
{
    public const CARRIER_IS_MODULE_VOTER = 'CARRIER_IS_MODULE_VOTER';
    private ShipmentRepository $shipmentRepository;

    public function __construct(ShipmentRepository $shipmentRepository)
    {
        $this->shipmentRepository = $shipmentRepository;
    }
    public function supports(string $type, $params): ?string
    {
        switch ($type) {
            case self::CARRIER_IS_MODULE_VOTER:
                return ($params instanceof \Carrier)?
                    'voteCarrierIsModule':
                    null;
            default:
                return null;
        }
    }

    public function voteCarrierIsModule(\Carrier $carrier)
    {
        $shipment = $this->shipmentRepository->findOneBy(['carrier' => $carrier->id_reference]);
        if (!$shipment) {
            return false;
        }
        return true;
    }
}
