<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class WebhookRegister implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $AuthorizationType;

    /**
     * @var string
     */
    private $UserName;

    /**
     * @var string
     */
    private $Password;

    /**
     * @var string
     */
    private $LoginUrl;

    /**
     * @var string
     */
    private $NotificationUrl;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $AuthorizationType
     * @var string $UserName
     * @var string $Password
     * @var string $LoginUrl
     * @var string $NotificationUrl
     */
    public function __construct($PartnerID, $PartnerKey, $AuthorizationType, $UserName, $Password, $LoginUrl, $NotificationUrl)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->AuthorizationType = $AuthorizationType;
        $this->UserName = $UserName;
        $this->Password = $Password;
        $this->LoginUrl = $LoginUrl;
        $this->NotificationUrl = $NotificationUrl;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return WebhookRegister
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return WebhookRegister
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getAuthorizationType()
    {
        return $this->AuthorizationType;
    }

    /**
     * @param string $AuthorizationType
     * @return WebhookRegister
     */
    public function withAuthorizationType($AuthorizationType)
    {
        $new = clone $this;
        $new->AuthorizationType = $AuthorizationType;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->UserName;
    }

    /**
     * @param string $UserName
     * @return WebhookRegister
     */
    public function withUserName($UserName)
    {
        $new = clone $this;
        $new->UserName = $UserName;

        return $new;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * @param string $Password
     * @return WebhookRegister
     */
    public function withPassword($Password)
    {
        $new = clone $this;
        $new->Password = $Password;

        return $new;
    }

    /**
     * @return string
     */
    public function getLoginUrl()
    {
        return $this->LoginUrl;
    }

    /**
     * @param string $LoginUrl
     * @return WebhookRegister
     */
    public function withLoginUrl($LoginUrl)
    {
        $new = clone $this;
        $new->LoginUrl = $LoginUrl;

        return $new;
    }

    /**
     * @return string
     */
    public function getNotificationUrl()
    {
        return $this->NotificationUrl;
    }

    /**
     * @param string $NotificationUrl
     * @return WebhookRegister
     */
    public function withNotificationUrl($NotificationUrl)
    {
        $new = clone $this;
        $new->NotificationUrl = $NotificationUrl;

        return $new;
    }


}

