<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class PointPwRSuggestion
{

    /**
     * @var string
     */
    private $DestinationCode;

    /**
     * @var int
     */
    private $PSD;

    /**
     * @var float
     */
    private $Distance;

    /**
     * @return string
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }

    /**
     * @param string $DestinationCode
     * @return PointPwRSuggestion
     */
    public function withDestinationCode($DestinationCode)
    {
        $new = clone $this;
        $new->DestinationCode = $DestinationCode;

        return $new;
    }

    /**
     * @return int
     */
    public function getPSD()
    {
        return $this->PSD;
    }

    /**
     * @param int $PSD
     * @return PointPwRSuggestion
     */
    public function withPSD($PSD)
    {
        $new = clone $this;
        $new->PSD = $PSD;

        return $new;
    }

    /**
     * @return float
     */
    public function getDistance()
    {
        return $this->Distance;
    }

    /**
     * @param float $Distance
     * @return PointPwRSuggestion
     */
    public function withDistance($Distance)
    {
        $new = clone $this;
        $new->Distance = $Distance;

        return $new;
    }


}

