<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class PointPwR
{

    /**
     * @var string
     */
    private $DestinationCode;

    /**
     * @var string
     */
    private $StreetName;

    /**
     * @var string
     */
    private $BuilingNumber;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $District;

    /**
     * @var string
     */
    private $Latitude;

    /**
     * @var string
     */
    private $Longitude;

    /**
     * @var string
     */
    private $Province;

    /**
     * @var bool
     */
    private $CashOnDelivery;

    /**
     * @var string
     */
    private $OpeningHours;

    /**
     * @var string
     */
    private $Location;

    /**
     * @var int
     */
    private $PSD;

    /**
     * @var string
     */
    private $PointType;

    /**
     * @var bool
     */
    private $Filled;

    /**
     * @var string
     */
    private $BuildingNumber;

    /**
     * @var bool
     */
    private $Available;

    /**
     * @var string
     */
    private $ZipCode;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfPointPwRSuggestion
     */
    private $Suggestions;

    /**
     * @return string
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }

    /**
     * @param string $DestinationCode
     * @return PointPwR
     */
    public function withDestinationCode($DestinationCode)
    {
        $new = clone $this;
        $new->DestinationCode = $DestinationCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }

    /**
     * @param string $StreetName
     * @return PointPwR
     */
    public function withStreetName($StreetName)
    {
        $new = clone $this;
        $new->StreetName = $StreetName;

        return $new;
    }

    /**
     * @return string
     */
    public function getBuilingNumber()
    {
        return $this->BuilingNumber;
    }

    /**
     * @param string $BuilingNumber
     * @return PointPwR
     */
    public function withBuilingNumber($BuilingNumber)
    {
        $new = clone $this;
        $new->BuilingNumber = $BuilingNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return PointPwR
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getDistrict()
    {
        return $this->District;
    }

    /**
     * @param string $District
     * @return PointPwR
     */
    public function withDistrict($District)
    {
        $new = clone $this;
        $new->District = $District;

        return $new;
    }

    /**
     * @return string
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }

    /**
     * @param string $Latitude
     * @return PointPwR
     */
    public function withLatitude($Latitude)
    {
        $new = clone $this;
        $new->Latitude = $Latitude;

        return $new;
    }

    /**
     * @return string
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }

    /**
     * @param string $Longitude
     * @return PointPwR
     */
    public function withLongitude($Longitude)
    {
        $new = clone $this;
        $new->Longitude = $Longitude;

        return $new;
    }

    /**
     * @return string
     */
    public function getProvince()
    {
        return $this->Province;
    }

    /**
     * @param string $Province
     * @return PointPwR
     */
    public function withProvince($Province)
    {
        $new = clone $this;
        $new->Province = $Province;

        return $new;
    }

    /**
     * @return bool
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }

    /**
     * @param bool $CashOnDelivery
     * @return PointPwR
     */
    public function withCashOnDelivery($CashOnDelivery)
    {
        $new = clone $this;
        $new->CashOnDelivery = $CashOnDelivery;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpeningHours()
    {
        return $this->OpeningHours;
    }

    /**
     * @param string $OpeningHours
     * @return PointPwR
     */
    public function withOpeningHours($OpeningHours)
    {
        $new = clone $this;
        $new->OpeningHours = $OpeningHours;

        return $new;
    }

    /**
     * @return string
     */
    public function getLocation()
    {
        return $this->Location;
    }

    /**
     * @param string $Location
     * @return PointPwR
     */
    public function withLocation($Location)
    {
        $new = clone $this;
        $new->Location = $Location;

        return $new;
    }

    /**
     * @return int
     */
    public function getPSD()
    {
        return $this->PSD;
    }

    /**
     * @param int $PSD
     * @return PointPwR
     */
    public function withPSD($PSD)
    {
        $new = clone $this;
        $new->PSD = $PSD;

        return $new;
    }

    /**
     * @return string
     */
    public function getPointType()
    {
        return $this->PointType;
    }

    /**
     * @param string $PointType
     * @return PointPwR
     */
    public function withPointType($PointType)
    {
        $new = clone $this;
        $new->PointType = $PointType;

        return $new;
    }

    /**
     * @return bool
     */
    public function getFilled()
    {
        return $this->Filled;
    }

    /**
     * @param bool $Filled
     * @return PointPwR
     */
    public function withFilled($Filled)
    {
        $new = clone $this;
        $new->Filled = $Filled;

        return $new;
    }

    /**
     * @return string
     */
    public function getBuildingNumber()
    {
        return $this->BuildingNumber;
    }

    /**
     * @param string $BuildingNumber
     * @return PointPwR
     */
    public function withBuildingNumber($BuildingNumber)
    {
        $new = clone $this;
        $new->BuildingNumber = $BuildingNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getAvailable()
    {
        return $this->Available;
    }

    /**
     * @param bool $Available
     * @return PointPwR
     */
    public function withAvailable($Available)
    {
        $new = clone $this;
        $new->Available = $Available;

        return $new;
    }

    /**
     * @return string
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }

    /**
     * @param string $ZipCode
     * @return PointPwR
     */
    public function withZipCode($ZipCode)
    {
        $new = clone $this;
        $new->ZipCode = $ZipCode;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfPointPwRSuggestion
     */
    public function getSuggestions()
    {
        return $this->Suggestions;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfPointPwRSuggestion $Suggestions
     * @return PointPwR
     */
    public function withSuggestions($Suggestions)
    {
        $new = clone $this;
        $new->Suggestions = $Suggestions;

        return $new;
    }


}

