<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class OrderPickupsFromLastDays implements RequestInterface
{

    /**
     * @var string
     */
    private $token;

    /**
     * @var string
     */
    private $partnerId;

    /**
     * Constructor
     *
     * @var string $token
     * @var string $partnerId
     */
    public function __construct($token, $partnerId)
    {
        $this->token = $token;
        $this->partnerId = $partnerId;
    }

    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @param string $token
     * @return OrderPickupsFromLastDays
     */
    public function withToken($token)
    {
        $new = clone $this;
        $new->token = $token;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerId()
    {
        return $this->partnerId;
    }

    /**
     * @param string $partnerId
     * @return OrderPickupsFromLastDays
     */
    public function withPartnerId($partnerId)
    {
        $new = clone $this;
        $new->partnerId = $partnerId;

        return $new;
    }


}

