<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class OpPudoDto
{

    /**
     * @var string
     */
    private $PSD;

    /**
     * @var string
     */
    private $PointType;

    /**
     * @var string
     */
    private $PointNetwork;

    /**
     * @var string
     */
    private $Address;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $Longitude;

    /**
     * @var string
     */
    private $Latitude;

    /**
     * @var string
     */
    private $Province;

    /**
     * @var string
     */
    private $Location;

    /**
     * @var string
     */
    private $OpenHoursMoStart;

    /**
     * @var string
     */
    private $OpenHoursMoEnd;

    /**
     * @var string
     */
    private $OpenHoursTuStart;

    /**
     * @var string
     */
    private $OpenHoursTuEnd;

    /**
     * @var string
     */
    private $OpenHoursWeStart;

    /**
     * @var string
     */
    private $OpenHoursWeEnd;

    /**
     * @var string
     */
    private $OpenHoursThStart;

    /**
     * @var string
     */
    private $OpenHoursThEnd;

    /**
     * @var string
     */
    private $OpenHoursFrStart;

    /**
     * @var string
     */
    private $OpenHoursFrEnd;

    /**
     * @var string
     */
    private $OpenHoursSaStart;

    /**
     * @var string
     */
    private $OpenHoursSaEnd;

    /**
     * @var string
     */
    private $OpenHoursSuStart;

    /**
     * @var string
     */
    private $OpenHoursSuEnd;

    /**
     * @var string
     */
    private $Available;

    /**
     * @var string
     */
    private $PointLastModifiedTimestamp;

    /**
     * @var string
     */
    private $LockersImageUrl;

    /**
     * @var string
     */
    private $LockersImageLastModifiedTimestamp;

    /**
     * @var string
     */
    private $CL;

    /**
     * @return string
     */
    public function getPSD()
    {
        return $this->PSD;
    }

    /**
     * @param string $PSD
     * @return OpPudoDto
     */
    public function withPSD($PSD)
    {
        $new = clone $this;
        $new->PSD = $PSD;

        return $new;
    }

    /**
     * @return string
     */
    public function getPointType()
    {
        return $this->PointType;
    }

    /**
     * @param string $PointType
     * @return OpPudoDto
     */
    public function withPointType($PointType)
    {
        $new = clone $this;
        $new->PointType = $PointType;

        return $new;
    }

    /**
     * @return string
     */
    public function getPointNetwork()
    {
        return $this->PointNetwork;
    }

    /**
     * @param string $PointNetwork
     * @return OpPudoDto
     */
    public function withPointNetwork($PointNetwork)
    {
        $new = clone $this;
        $new->PointNetwork = $PointNetwork;

        return $new;
    }

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }

    /**
     * @param string $Address
     * @return OpPudoDto
     */
    public function withAddress($Address)
    {
        $new = clone $this;
        $new->Address = $Address;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return OpPudoDto
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return OpPudoDto
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }

    /**
     * @param string $Longitude
     * @return OpPudoDto
     */
    public function withLongitude($Longitude)
    {
        $new = clone $this;
        $new->Longitude = $Longitude;

        return $new;
    }

    /**
     * @return string
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }

    /**
     * @param string $Latitude
     * @return OpPudoDto
     */
    public function withLatitude($Latitude)
    {
        $new = clone $this;
        $new->Latitude = $Latitude;

        return $new;
    }

    /**
     * @return string
     */
    public function getProvince()
    {
        return $this->Province;
    }

    /**
     * @param string $Province
     * @return OpPudoDto
     */
    public function withProvince($Province)
    {
        $new = clone $this;
        $new->Province = $Province;

        return $new;
    }

    /**
     * @return string
     */
    public function getLocation()
    {
        return $this->Location;
    }

    /**
     * @param string $Location
     * @return OpPudoDto
     */
    public function withLocation($Location)
    {
        $new = clone $this;
        $new->Location = $Location;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursMoStart()
    {
        return $this->OpenHoursMoStart;
    }

    /**
     * @param string $OpenHoursMoStart
     * @return OpPudoDto
     */
    public function withOpenHoursMoStart($OpenHoursMoStart)
    {
        $new = clone $this;
        $new->OpenHoursMoStart = $OpenHoursMoStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursMoEnd()
    {
        return $this->OpenHoursMoEnd;
    }

    /**
     * @param string $OpenHoursMoEnd
     * @return OpPudoDto
     */
    public function withOpenHoursMoEnd($OpenHoursMoEnd)
    {
        $new = clone $this;
        $new->OpenHoursMoEnd = $OpenHoursMoEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursTuStart()
    {
        return $this->OpenHoursTuStart;
    }

    /**
     * @param string $OpenHoursTuStart
     * @return OpPudoDto
     */
    public function withOpenHoursTuStart($OpenHoursTuStart)
    {
        $new = clone $this;
        $new->OpenHoursTuStart = $OpenHoursTuStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursTuEnd()
    {
        return $this->OpenHoursTuEnd;
    }

    /**
     * @param string $OpenHoursTuEnd
     * @return OpPudoDto
     */
    public function withOpenHoursTuEnd($OpenHoursTuEnd)
    {
        $new = clone $this;
        $new->OpenHoursTuEnd = $OpenHoursTuEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursWeStart()
    {
        return $this->OpenHoursWeStart;
    }

    /**
     * @param string $OpenHoursWeStart
     * @return OpPudoDto
     */
    public function withOpenHoursWeStart($OpenHoursWeStart)
    {
        $new = clone $this;
        $new->OpenHoursWeStart = $OpenHoursWeStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursWeEnd()
    {
        return $this->OpenHoursWeEnd;
    }

    /**
     * @param string $OpenHoursWeEnd
     * @return OpPudoDto
     */
    public function withOpenHoursWeEnd($OpenHoursWeEnd)
    {
        $new = clone $this;
        $new->OpenHoursWeEnd = $OpenHoursWeEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursThStart()
    {
        return $this->OpenHoursThStart;
    }

    /**
     * @param string $OpenHoursThStart
     * @return OpPudoDto
     */
    public function withOpenHoursThStart($OpenHoursThStart)
    {
        $new = clone $this;
        $new->OpenHoursThStart = $OpenHoursThStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursThEnd()
    {
        return $this->OpenHoursThEnd;
    }

    /**
     * @param string $OpenHoursThEnd
     * @return OpPudoDto
     */
    public function withOpenHoursThEnd($OpenHoursThEnd)
    {
        $new = clone $this;
        $new->OpenHoursThEnd = $OpenHoursThEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursFrStart()
    {
        return $this->OpenHoursFrStart;
    }

    /**
     * @param string $OpenHoursFrStart
     * @return OpPudoDto
     */
    public function withOpenHoursFrStart($OpenHoursFrStart)
    {
        $new = clone $this;
        $new->OpenHoursFrStart = $OpenHoursFrStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursFrEnd()
    {
        return $this->OpenHoursFrEnd;
    }

    /**
     * @param string $OpenHoursFrEnd
     * @return OpPudoDto
     */
    public function withOpenHoursFrEnd($OpenHoursFrEnd)
    {
        $new = clone $this;
        $new->OpenHoursFrEnd = $OpenHoursFrEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursSaStart()
    {
        return $this->OpenHoursSaStart;
    }

    /**
     * @param string $OpenHoursSaStart
     * @return OpPudoDto
     */
    public function withOpenHoursSaStart($OpenHoursSaStart)
    {
        $new = clone $this;
        $new->OpenHoursSaStart = $OpenHoursSaStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursSaEnd()
    {
        return $this->OpenHoursSaEnd;
    }

    /**
     * @param string $OpenHoursSaEnd
     * @return OpPudoDto
     */
    public function withOpenHoursSaEnd($OpenHoursSaEnd)
    {
        $new = clone $this;
        $new->OpenHoursSaEnd = $OpenHoursSaEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursSuStart()
    {
        return $this->OpenHoursSuStart;
    }

    /**
     * @param string $OpenHoursSuStart
     * @return OpPudoDto
     */
    public function withOpenHoursSuStart($OpenHoursSuStart)
    {
        $new = clone $this;
        $new->OpenHoursSuStart = $OpenHoursSuStart;

        return $new;
    }

    /**
     * @return string
     */
    public function getOpenHoursSuEnd()
    {
        return $this->OpenHoursSuEnd;
    }

    /**
     * @param string $OpenHoursSuEnd
     * @return OpPudoDto
     */
    public function withOpenHoursSuEnd($OpenHoursSuEnd)
    {
        $new = clone $this;
        $new->OpenHoursSuEnd = $OpenHoursSuEnd;

        return $new;
    }

    /**
     * @return string
     */
    public function getAvailable()
    {
        return $this->Available;
    }

    /**
     * @param string $Available
     * @return OpPudoDto
     */
    public function withAvailable($Available)
    {
        $new = clone $this;
        $new->Available = $Available;

        return $new;
    }

    /**
     * @return string
     */
    public function getPointLastModifiedTimestamp()
    {
        return $this->PointLastModifiedTimestamp;
    }

    /**
     * @param string $PointLastModifiedTimestamp
     * @return OpPudoDto
     */
    public function withPointLastModifiedTimestamp($PointLastModifiedTimestamp)
    {
        $new = clone $this;
        $new->PointLastModifiedTimestamp = $PointLastModifiedTimestamp;

        return $new;
    }

    /**
     * @return string
     */
    public function getLockersImageUrl()
    {
        return $this->LockersImageUrl;
    }

    /**
     * @param string $LockersImageUrl
     * @return OpPudoDto
     */
    public function withLockersImageUrl($LockersImageUrl)
    {
        $new = clone $this;
        $new->LockersImageUrl = $LockersImageUrl;

        return $new;
    }

    /**
     * @return string
     */
    public function getLockersImageLastModifiedTimestamp()
    {
        return $this->LockersImageLastModifiedTimestamp;
    }

    /**
     * @param string $LockersImageLastModifiedTimestamp
     * @return OpPudoDto
     */
    public function withLockersImageLastModifiedTimestamp($LockersImageLastModifiedTimestamp)
    {
        $new = clone $this;
        $new->LockersImageLastModifiedTimestamp = $LockersImageLastModifiedTimestamp;

        return $new;
    }

    /**
     * @return string
     */
    public function getCL()
    {
        return $this->CL;
    }

    /**
     * @param string $CL
     * @return OpPudoDto
     */
    public function withCL($CL)
    {
        $new = clone $this;
        $new->CL = $CL;

        return $new;
    }


}

