<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GiveMePackStatusList implements RequestInterface
{

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    private $PackCodes;

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * Constructor
     *
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $PackCodes
     * @var string $PartnerID
     * @var string $PartnerKey
     */
    public function __construct($PackCodes, $PartnerID, $PartnerKey)
    {
        $this->PackCodes = $PackCodes;
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    public function getPackCodes()
    {
        return $this->PackCodes;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $PackCodes
     * @return GiveMePackStatusList
     */
    public function withPackCodes($PackCodes)
    {
        $new = clone $this;
        $new->PackCodes = $PackCodes;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GiveMePackStatusList
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GiveMePackStatusList
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }


}

