<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GetAvailablePickups implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $Street;

    /**
     * @var string
     */
    private $BuildingNo;

    /**
     * @var string
     */
    private $Email;

    /**
     * @var string
     */
    private $PartnerName;

    /**
     * @var string
     */
    private $PersonName;

    /**
     * @var string
     */
    private $PersonSurname;

    /**
     * @var string
     */
    private $Telephone;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $PostCode
     * @var string $City
     * @var string $Street
     * @var string $BuildingNo
     * @var string $Email
     * @var string $PartnerName
     * @var string $PersonName
     * @var string $PersonSurname
     * @var string $Telephone
     */
    public function __construct($PartnerID, $PartnerKey, $PostCode, $City, $Street, $BuildingNo, $Email, $PartnerName, $PersonName, $PersonSurname, $Telephone)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PostCode = $PostCode;
        $this->City = $City;
        $this->Street = $Street;
        $this->BuildingNo = $BuildingNo;
        $this->Email = $Email;
        $this->PartnerName = $PartnerName;
        $this->PersonName = $PersonName;
        $this->PersonSurname = $PersonSurname;
        $this->Telephone = $Telephone;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GetAvailablePickups
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GetAvailablePickups
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return GetAvailablePickups
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return GetAvailablePickups
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->Street;
    }

    /**
     * @param string $Street
     * @return GetAvailablePickups
     */
    public function withStreet($Street)
    {
        $new = clone $this;
        $new->Street = $Street;

        return $new;
    }

    /**
     * @return string
     */
    public function getBuildingNo()
    {
        return $this->BuildingNo;
    }

    /**
     * @param string $BuildingNo
     * @return GetAvailablePickups
     */
    public function withBuildingNo($BuildingNo)
    {
        $new = clone $this;
        $new->BuildingNo = $BuildingNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }

    /**
     * @param string $Email
     * @return GetAvailablePickups
     */
    public function withEmail($Email)
    {
        $new = clone $this;
        $new->Email = $Email;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerName()
    {
        return $this->PartnerName;
    }

    /**
     * @param string $PartnerName
     * @return GetAvailablePickups
     */
    public function withPartnerName($PartnerName)
    {
        $new = clone $this;
        $new->PartnerName = $PartnerName;

        return $new;
    }

    /**
     * @return string
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }

    /**
     * @param string $PersonName
     * @return GetAvailablePickups
     */
    public function withPersonName($PersonName)
    {
        $new = clone $this;
        $new->PersonName = $PersonName;

        return $new;
    }

    /**
     * @return string
     */
    public function getPersonSurname()
    {
        return $this->PersonSurname;
    }

    /**
     * @param string $PersonSurname
     * @return GetAvailablePickups
     */
    public function withPersonSurname($PersonSurname)
    {
        $new = clone $this;
        $new->PersonSurname = $PersonSurname;

        return $new;
    }

    /**
     * @return string
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }

    /**
     * @param string $Telephone
     * @return GetAvailablePickups
     */
    public function withTelephone($Telephone)
    {
        $new = clone $this;
        $new->Telephone = $Telephone;

        return $new;
    }


}

