<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateNumberWaybills implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $NumberOfWaybills;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $NumberOfWaybills
     */
    public function __construct($PartnerID, $PartnerKey, $NumberOfWaybills)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->NumberOfWaybills = $NumberOfWaybills;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateNumberWaybills
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateNumberWaybills
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getNumberOfWaybills()
    {
        return $this->NumberOfWaybills;
    }

    /**
     * @param string $NumberOfWaybills
     * @return GenerateNumberWaybills
     */
    public function withNumberOfWaybills($NumberOfWaybills)
    {
        $new = clone $this;
        $new->NumberOfWaybills = $NumberOfWaybills;

        return $new;
    }


}

