<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\ResultInterface;

class GenerateLabelBusinessPackResponse implements ResultInterface
{

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackResult
     */
    private $GenerateLabelBusinessPackResult;

    /**
     * @var string
     */
    private $LabelData;

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackResult
     */
    public function getGenerateLabelBusinessPackResult()
    {
        return $this->GenerateLabelBusinessPackResult;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackResult $GenerateLabelBusinessPackResult
     * @return GenerateLabelBusinessPackResponse
     */
    public function withGenerateLabelBusinessPackResult($GenerateLabelBusinessPackResult)
    {
        $new = clone $this;
        $new->GenerateLabelBusinessPackResult = $GenerateLabelBusinessPackResult;

        return $new;
    }

    /**
     * @return string
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }

    /**
     * @param string $LabelData
     * @return GenerateLabelBusinessPackResponse
     */
    public function withLabelData($LabelData)
    {
        $new = clone $this;
        $new->LabelData = $LabelData;

        return $new;
    }


}

