<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateLabelBusinessPackListAllegro implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $AutoDestinationChange;

    /**
     * @var string
     */
    private $Format;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPackAllegro
     */
    private $BusinessPackList;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $AutoDestinationChange
     * @var string $Format
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPackAllegro $BusinessPackList
     */
    public function __construct($PartnerID, $PartnerKey, $AutoDestinationChange, $Format, $BusinessPackList)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->AutoDestinationChange = $AutoDestinationChange;
        $this->Format = $Format;
        $this->BusinessPackList = $BusinessPackList;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateLabelBusinessPackListAllegro
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateLabelBusinessPackListAllegro
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getAutoDestinationChange()
    {
        return $this->AutoDestinationChange;
    }

    /**
     * @param string $AutoDestinationChange
     * @return GenerateLabelBusinessPackListAllegro
     */
    public function withAutoDestinationChange($AutoDestinationChange)
    {
        $new = clone $this;
        $new->AutoDestinationChange = $AutoDestinationChange;

        return $new;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }

    /**
     * @param string $Format
     * @return GenerateLabelBusinessPackListAllegro
     */
    public function withFormat($Format)
    {
        $new = clone $this;
        $new->Format = $Format;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPackAllegro
     */
    public function getBusinessPackList()
    {
        return $this->BusinessPackList;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPackAllegro $BusinessPackList
     * @return GenerateLabelBusinessPackListAllegro
     */
    public function withBusinessPackList($BusinessPackList)
    {
        $new = clone $this;
        $new->BusinessPackList = $BusinessPackList;

        return $new;
    }


}

