<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateCustomerReturn implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $PackCode;

    /**
     * @var string
     */
    private $SenderPhoneNumber;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $PackCode
     * @var string $SenderPhoneNumber
     */
    public function __construct($PartnerID, $PartnerKey, $PackCode, $SenderPhoneNumber)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PackCode = $PackCode;
        $this->SenderPhoneNumber = $SenderPhoneNumber;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateCustomerReturn
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateCustomerReturn
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }

    /**
     * @param string $PackCode
     * @return GenerateCustomerReturn
     */
    public function withPackCode($PackCode)
    {
        $new = clone $this;
        $new->PackCode = $PackCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderPhoneNumber()
    {
        return $this->SenderPhoneNumber;
    }

    /**
     * @param string $SenderPhoneNumber
     * @return GenerateCustomerReturn
     */
    public function withSenderPhoneNumber($SenderPhoneNumber)
    {
        $new = clone $this;
        $new->SenderPhoneNumber = $SenderPhoneNumber;

        return $new;
    }


}

