<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class CallPickupNew implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    private $PackList;

    /**
     * @var \DateTimeInterface
     */
    private $ReadyDate;

    /**
     * @var \DateTimeInterface
     */
    private $PickupDate;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $Street;

    /**
     * @var string
     */
    private $BuildingNo;

    /**
     * @var string
     */
    private $Email;

    /**
     * @var string
     */
    private $PartnerName;

    /**
     * @var string
     */
    private $PersonName;

    /**
     * @var string
     */
    private $PersonSurname;

    /**
     * @var string
     */
    private $Telephone;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $PackList
     * @var \DateTimeInterface $ReadyDate
     * @var \DateTimeInterface $PickupDate
     * @var string $PostCode
     * @var string $City
     * @var string $Street
     * @var string $BuildingNo
     * @var string $Email
     * @var string $PartnerName
     * @var string $PersonName
     * @var string $PersonSurname
     * @var string $Telephone
     */
    public function __construct($PartnerID, $PartnerKey, $PackList, $ReadyDate, $PickupDate, $PostCode, $City, $Street, $BuildingNo, $Email, $PartnerName, $PersonName, $PersonSurname, $Telephone)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PackList = $PackList;
        $this->ReadyDate = $ReadyDate;
        $this->PickupDate = $PickupDate;
        $this->PostCode = $PostCode;
        $this->City = $City;
        $this->Street = $Street;
        $this->BuildingNo = $BuildingNo;
        $this->Email = $Email;
        $this->PartnerName = $PartnerName;
        $this->PersonName = $PersonName;
        $this->PersonSurname = $PersonSurname;
        $this->Telephone = $Telephone;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return CallPickupNew
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return CallPickupNew
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    public function getPackList()
    {
        return $this->PackList;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $PackList
     * @return CallPickupNew
     */
    public function withPackList($PackList)
    {
        $new = clone $this;
        $new->PackList = $PackList;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getReadyDate()
    {
        return $this->ReadyDate;
    }

    /**
     * @param \DateTimeInterface $ReadyDate
     * @return CallPickupNew
     */
    public function withReadyDate($ReadyDate)
    {
        $new = clone $this;
        $new->ReadyDate = $ReadyDate;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }

    /**
     * @param \DateTimeInterface $PickupDate
     * @return CallPickupNew
     */
    public function withPickupDate($PickupDate)
    {
        $new = clone $this;
        $new->PickupDate = $PickupDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return CallPickupNew
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return CallPickupNew
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->Street;
    }

    /**
     * @param string $Street
     * @return CallPickupNew
     */
    public function withStreet($Street)
    {
        $new = clone $this;
        $new->Street = $Street;

        return $new;
    }

    /**
     * @return string
     */
    public function getBuildingNo()
    {
        return $this->BuildingNo;
    }

    /**
     * @param string $BuildingNo
     * @return CallPickupNew
     */
    public function withBuildingNo($BuildingNo)
    {
        $new = clone $this;
        $new->BuildingNo = $BuildingNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }

    /**
     * @param string $Email
     * @return CallPickupNew
     */
    public function withEmail($Email)
    {
        $new = clone $this;
        $new->Email = $Email;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerName()
    {
        return $this->PartnerName;
    }

    /**
     * @param string $PartnerName
     * @return CallPickupNew
     */
    public function withPartnerName($PartnerName)
    {
        $new = clone $this;
        $new->PartnerName = $PartnerName;

        return $new;
    }

    /**
     * @return string
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }

    /**
     * @param string $PersonName
     * @return CallPickupNew
     */
    public function withPersonName($PersonName)
    {
        $new = clone $this;
        $new->PersonName = $PersonName;

        return $new;
    }

    /**
     * @return string
     */
    public function getPersonSurname()
    {
        return $this->PersonSurname;
    }

    /**
     * @param string $PersonSurname
     * @return CallPickupNew
     */
    public function withPersonSurname($PersonSurname)
    {
        $new = clone $this;
        $new->PersonSurname = $PersonSurname;

        return $new;
    }

    /**
     * @return string
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }

    /**
     * @param string $Telephone
     * @return CallPickupNew
     */
    public function withTelephone($Telephone)
    {
        $new = clone $this;
        $new->Telephone = $Telephone;

        return $new;
    }


}

