<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class AvailablePickupDay
{

    /**
     * @var string
     */
    private $Date;

    /**
     * @var string
     */
    private $MinReadyDate;

    /**
     * @var string
     */
    private $MaxPickupDate;

    /**
     * @var int
     */
    private $MinimumInterval;

    /**
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @param string $Date
     * @return AvailablePickupDay
     */
    public function withDate($Date)
    {
        $new = clone $this;
        $new->Date = $Date;

        return $new;
    }

    /**
     * @return string
     */
    public function getMinReadyDate()
    {
        return $this->MinReadyDate;
    }

    /**
     * @param string $MinReadyDate
     * @return AvailablePickupDay
     */
    public function withMinReadyDate($MinReadyDate)
    {
        $new = clone $this;
        $new->MinReadyDate = $MinReadyDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getMaxPickupDate()
    {
        return $this->MaxPickupDate;
    }

    /**
     * @param string $MaxPickupDate
     * @return AvailablePickupDay
     */
    public function withMaxPickupDate($MaxPickupDate)
    {
        $new = clone $this;
        $new->MaxPickupDate = $MaxPickupDate;

        return $new;
    }

    /**
     * @return int
     */
    public function getMinimumInterval()
    {
        return $this->MinimumInterval;
    }

    /**
     * @param int $MinimumInterval
     * @return AvailablePickupDay
     */
    public function withMinimumInterval($MinimumInterval)
    {
        $new = clone $this;
        $new->MinimumInterval = $MinimumInterval;

        return $new;
    }


}

