<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka;

use Orlen\OrlenPaczka\Authorization\Dto\ConnectionInterface;
use Orlen\OrlenPaczka\Authorization\Provider\ConnectionProviderInterface;
use Orlen\OrlenPaczka\Logger\Driver\ApiDriver;
use Orlen\OrlenPaczka\Logger\Factory\LoggerFactory;
use Orlen\OrlenPaczka\Soap\Client\Caller\EngineCaller;
use Orlen\OrlenPaczka\Soap\Client\Caller\LoggingCaller;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\ExtSoapEngineFactory;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\ExtSoapOptions;
use Psr\Log\LoggerInterface;

class OrlenPaczkaClientFactory
{

    private ConnectionProviderInterface $connectionProvider;
    private ConnectionInterface $connection;
    private LoggerInterface $logger;

    public function __construct(ConnectionProviderInterface $connectionProvider, LoggerFactory $loggerFactory)
    {
        $this->connectionProvider = $connectionProvider;
        $this->logger = $loggerFactory->getLogger(ApiDriver::NAME, 'CORE');
    }

    public function factory() : OrlenPaczkaClient
    {
        try{
            $this->setConnection();
            $engine = ExtSoapEngineFactory::fromOptions(
                ExtSoapOptions::defaults($this->connection->getWsdl(), [])
                    ->setClassMap(OrlenPaczkaClassmap::getCollection())
            );

            $caller = new EngineCaller($engine);
            $caller = new LoggingCaller($caller, $this->logger);

            return new OrlenPaczkaClient($caller, $this->connection->getCredentials(), $this->connection->isSandbox());
        }catch (\Throwable $e){
            $this->logger->error('Error creating OrlenPaczkaClient', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            throw $e;
        }

    }

    private function setConnection()
    {
        if (!isset($this->connection) || !($this->connection instanceof ConnectionInterface)) {
            $this->connection = $this->connectionProvider->getConnection();
        }
    }

    public function resetConnection()
    {
        unset($this->connection);
    }


}

