/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'uiComponent',
    'Magento_Checkout/js/model/shipping-rates-validator',
    'Magento_Checkout/js/model/shipping-rates-validation-rules',
    '../../model/shipping-rates-validator/orlenpaczka',
    '../../model/shipping-rates-validation-rules/orlenpaczka'
], function (
    Component,
    defaultShippingRatesValidator,
    defaultShippingRatesValidationRules,
    orlenShippingRatesValidator,
    orlenShippingRatesValidationRules
) {
    'use strict';

    defaultShippingRatesValidator.registerValidator('orlenpaczka', orlenShippingRatesValidator);
    defaultShippingRatesValidationRules.registerRules('orlenpaczka', orlenShippingRatesValidationRules);

    return Component;
});
