<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Ui\Component\Shipment\Protocol\Listing;

use Magento\Ui\DataProvider\AbstractDataProvider;
use Macopedia\OrlenShipping\Model\ResourceModel\Protocol\Grid\Collection as GridCollection;
use Macopedia\OrlenShipping\Model\ResourceModel\Protocol\Grid\CollectionFactory;

class DataProvider extends AbstractDataProvider
{
    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $collectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        string $name,
        string $primaryFieldName,
        string $requestFieldName,
        CollectionFactory $collectionFactory,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collectionFactory->create();
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $meta,
            $data
        );
    }

    /**
     * Get data
     *
     * @return array
     */
    public function getData(): array
    {
        /** @var GridCollection $collection */
        $collection = $this->getCollection();

        return $collection->toArray();
    }
}
