<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Ui\Component\Shipment\CourierOrder\Listing;

use Macopedia\OrlenShipping\Model\ResourceModel\CourierOrder\Grid\Collection as GridCollection;
use Macopedia\OrlenShipping\Model\ResourceModel\CourierOrder\Grid\CollectionFactory;
use Magento\Ui\DataProvider\AbstractDataProvider;

class DataProvider extends AbstractDataProvider
{
    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $collectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * Get data
     *
     * @return array
     */
    public function getData(): array
    {
        /** @var GridCollection $collection */
        $collection = $this->getCollection();

        return $collection->toArray();
    }
}
