<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Setup\Patch\Data;

use Macopedia\OrlenShipping\Model\Carrier\OrlenShipping;
use Magento\Catalog\Model\Product\AttributeSet\Options;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class DisableOrlenDeliveryAttributeDataPatch implements DataPatchInterface
{
    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetup $eavSetup
     * @param Options $attributeSetOptions
     */
    public function __construct(
        protected readonly ModuleDataSetupInterface $moduleDataSetup,
        protected readonly EavSetup $eavSetup,
        protected readonly Options $attributeSetOptions
    ) {
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function apply(): void
    {
        $this->moduleDataSetup->startSetup();

        $this->eavSetup->addAttribute(
            'catalog_product',
            OrlenShipping::ORLEN_DISABLE_DELIVERY_ATTR,
            [
                'type' => 'int',
                'label' => 'Disable ORLEN Paczka delivery',
                'input' => 'boolean',
                'global' => ScopedAttributeInterface::SCOPE_STORE,
                'visible' => true,
                'required' => false,
                'user_defined' => true,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => false,
                'unique' => false,
            ]
        );

        foreach ($this->attributeSetOptions->toOptionArray() as $attributeSet) {
            if (isset($attributeSet['value'])) {
                $this->eavSetup->addAttributeToSet(
                    'catalog_product',
                    $attributeSet['value'],
                    'General',
                    OrlenShipping::ORLEN_DISABLE_DELIVERY_ATTR
                );
            }
        }

        $this->moduleDataSetup->endSetup();
    }
}
