# ORLEN Paczka Magento 2 module by Macopedia

## Kompatybilność
- Magento 2.4.7 & 2.4.8
- PHP >= 8.1

## Funkcjonalności
1. Mapa w checkoucie z wyborem punktów odbioru ORLEN Paczka
2. Generowanie numerów paczek i etykiet
3. Generowanie protokołu zbiorczo-nadawczego
4. Zamawianie kuriera

## Instalacja
1. Rozpakuj plik ZIP
   Po rozpakowaniu pobranego archiwum ZIP na komputerze znajdziesz katalog Macopedia, a w nim OrlenShipping

2. Skopiuj moduł do katalogu Magento
   Przenieś cały katalog Macopedia do ścieżki: app/code/

3. Włącz moduł przy pomocy klienta SSH
   Używając klienta SSH, wykonaj następującą komendę:
   php bin/magento module:enable Macopedia_OrlenShipping

4. Wykonaj upgrade bazy danych
   Następnie zaktualizuj bazę danych, wpisując komendę:
   php bin/magento setup:upgrade

5. Wyczyść cache Magento
   Na koniec wyczyść cache Magento, używając komendy:
   php bin/magento cache:clean

## Konfiguracja modułu
Konfiguracja znajduje się w Sklepy>Konfiguracja>Sprzedaż>Metody Dostawy (Stores->Configuration->Sales->Delivery Methods) w sekcji ORLEN Paczka.

1. Włącz metodę dostawy
   ![config_enable](README/config_enable.png)
2. Wprowadź Token widgetu mapy - aby go uzyskać, skontaktuj się z działem integracji pod adresem integracje@orlenpaczka.pl
   ![config_token](README/config_token.png)
3. Wprowadź dane dostępowe - PartnerID oraz PartnerKey
   ![config_pass](README/config_pass.png)
4. Określ, czy moduł ma łączyć się do środowiska testowego, czy produkcyjnego API ORLEN Paczki. UWAGA - dane dostępowe do środowiska testowego różnią się od danych produkcyjnych!
   ![config_sandbox](README/config_sandbox.png)
5. Sprawdź połączenie z API oraz poprawność wprowadzonych danych logowania
   ![config_test](README/config_test.png)
6. Tryb debugowania - jeżeli jest włączony, wszystkie zapytania oraz odpowiedzi API będą zapisywane w var/log/orlen-package.log
   ![config_debug](README/config_debug.png)
7. Zdefiniuj tytuł, nazwę metody oraz koszt przesyłki
   ![config_name](README/config_name.png)
8. Zdefiniuj darmową dostawę (niewymagane, może pozostać domyślne)
   ![config_free_delivery](README/config_free_delivery.png)
9. Zdefiniuj dozwolone kraje dostawy (niewymagane, może pozostać domyślne)
   ![config_contries](README/config_contries.png)
10. Określ kolejność sortowania metody dostawy w checkoucie
    ![config_sort_order](README/config_sort_order.png)
11. Wybierz domyślny rozmiar przesyłki
    ![config_pack_size](README/config_pack_size.png)
12. Uzupełnij dane adresowe. Będą one używane jako dane nadawcy przy zamawianiu kuriera oraz tworzeniu przesyłek
    ![config_address](README/config_address.png)

## Mapa punktów odbioru
Użytkownik podczas składania zamówienia ma możliwość wyboru punktu odbioru z mapy dostępnej w checkoucie. Po złożeniu zamówienia punkt odbioru można zmienić ręcznie w panelu administratora. UWAGA - zmiana punktu nie spowoduje zmian w przesyłce dla której została wygenerowana etykieta.
![checkout](README/checkout.png)
Aby zmienić punkt odbioru, należy wejść w widok konkretnego zamówienia i wybrać opcję Zmień punkt odbioru.
![change_point](README/change_point.png)
## Generowanie numerów paczek i etykiet

### Generowanie numeru paczki i etykiety dla jednego zamówienia
1. Wejdź na listę zamówień - Sprzedaż>Zamówienia (Sales->Orders)
2. Wybierz zamówienie, które zostało złożone z metodą dostawy ORLEN Paczka
   ![sales_order](README/sales_order.png)
3. Wybierz opcję Dostawa (Ship)
   ![ship](README/ship.png)
4. Wybierz ilości produktów, które chcesz, aby znalazły się w przesyłce
   ![choose_items](README/choose_items.png)
5. Wprowadź dane referencyjne (widoczne na etykiecie)
   ![sender_orders](README/sender_orders.png)
6. Określ czy przesyłka ma być ubezpieczona i wprowadź wartość przesyłki (usługa ubezpieczenia jest płatna, jeżeli wartość przekracza 1000 PLN)
   ![pack_value](README/pack_value.png)
8. Wybierz rozmiar przesyłki
   ![pack_size](README/pack_size.png)
9. Aby wygenerować etykietę, wybierz opcję Utwórz etykietę wysyłki (Create Shipping Label)
   ![submit_shipment](README/submit_shipment.png)
10. Dodaj produkty do przesyłki
    ![add_products](README/add_products.png)
11. Jeżeli produkty będą ważyć powyżej 20kg, masz możliwość podzielenia danej przesyłki na mniejsze za pomocą opcji Dodaj paczkę (Add Package)
    ![add_package](README/add_package.png)
11. Po rozdzieleniu produktów na przesyłki kliknij przycisk Zapisz (Save)

Wygenerowaną przesyłkę można podejrzeć, wchodząc w sekcję Dostawy (Shipments).
![view_package](README/view_package.png)
W widoku przesyłki można zobaczyć wybrane opcje oraz pobrać etykietę za pomocą opcji Wydrukuj etykietę wysyłkową (Print Shipping Label).
![print_shipping_label](README/print_shipping_label.png)

W celu umożliwienia modyfikacji danych przesyłanych podczas tworzenia przesyłki utworzyliśmy event `macopedia_orlen_before_generate_label`.
```
Macopedia\OrlenShipping\Model\Api\Pack:

$this->eventManager->dispatch('macopedia_orlen_before_generate_label', [
    'order' => $order,
    'request' => $request,
]);
```
Jest on uruchamiany przed wysłaniem request'u do API.

### Historia nadań
Historia nadań znajduje się w Sprzedaż->Dostawy (Sales->Shipments). Z tego widoku można generować protokoły zbiorczo-nadawcze, zamawiać kuriera, ale również pobierać wiele etykiet naraz. Wystarczy zaznaczyć kilka przesyłek i wybrać opcję Drukuj etykiety adresowe (Print Shipping Labels).
![print_shipping_labels](README/print_shipping_labels.png)

Aby wyświetlić wszystkie dostępne informacje w historii nadań, należy uwidocznić następujące kolumny:
- Dostawa do (Shipping Information)
- Dane referencyjne
- Wartość przesyłki
- Numer protokołu
- Rozmiar przesyłki

Dane można sortować oraz wyszukiwać po wszystkich kolumnach.

## Generowanie protokołu zbiorczo-nadawczego
Aby wygenerować protokół zbiorczo-nadawczy należy wejść w historię nadań (Sales->Shipments), zaznaczyć odpowiednie przesyłki i wybrać opcję Wygeneruj protokół ORLEN Paczka.
![generate_protocols](README/generate_protocols.png)
Potwierdzenie protokołu można pobrać, wchodząc w Sprzedaż->Protokoły przekazania. Przesyłki będą również miały przypisane odpowiednie numery protokołów.
![download_protocol](README/download_protocol.png)

## Zamawianie kuriera
Aby zamówić kuriera, należy wejść w historię nadań (Sales->Shipments), zaznaczyć odpowiednie przesyłki i wybrać opcję Zamów kuriera.
![order_courier](README/order_courier.png)
Następnie wybrać dzień odbioru oraz przedział czasowy.
![pick_time](README/pick_time.png)
Historia zamówień kurierów jest dostępna w Sprzedaż->Zlecenia kurierskie.
![couriers_grid](README/couriers_grid.png)

## Wyłączenie dostawy ORLEN Paczka dla wybranego produktu
Aby zablokować możliwość dostawy metodą ORLEN Paczka dla danego produktu, zaznacz opcję „Wyłącz dostawę ORLEN Paczka” w ustawieniach produktu w panelu administracyjnym.
![disable_delivery_attribute](README/disable_delivery_attribute.png)

## Integracja z zewnętrznymi serwisami

### Tworzenie zamówień z wybraną metodą dostawy ORLEN Paczka przez REST API
Udostępniamy możliwość tworzenia zamówień z metodą dostawy ORLEN Paczka przez REST API.
Aby takie zamówienia miały możliwość wystawienia przesyłki z Magento należy spełnić następujące wymagania:

Instrukcja oparta jest o tutorial tworzenia zamówienia przez REST API od [Adobe](https://developer.adobe.com/commerce/webapi/rest/tutorials/orders/).

1. Wybrać metodę dostawy ORLEN Paczka:
```
shipping_method_code: orlenpaczka
shipping_carrier_code: orlenpaczka
```
2. Po złożeniu zamówienia zaktualizować je o następujący extension attribute (wprowadzić destination code punktu odbioru):
```
"extension_attributes": {
    "orlenpaczka_destination_code": "destination code punktu odbioru",
    "orlenpaczka_point_details": "informacje adresowe wybranego punktu (ulica, kod pocztowy, miasto)"
}
```
Destination code jest wymagane do wystawienia etykiety.

### Tworzenie przesyłki dla zamówienia w Magento przez zewnętrzny serwis
Dane o wybranym punkcie odbioru będą widoczne w extension attributes po pobraniu zamówienia przez REST API:
```
"extension_attributes": {
    "orlenpaczka_destination_code": "destination code punktu odbioru",
    "orlenpaczka_point_details": "informacje adresowe wybranego punktu (ulica, kod pocztowy, miasto)"
}
```
