<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Plugin;

use Magento\Shipping\Controller\Adminhtml\Order\ShipmentLoader;
use Magento\Sales\Model\Order\Shipment;

class ShipmentLoaderPlugin
{
    /**
     * After load shipment plugin
     *
     * @param ShipmentLoader $subject
     * @param bool|Shipment $result
     * @return bool|Shipment
     */
    public function afterLoad(ShipmentLoader $subject, bool|Shipment $result): bool|Shipment
    {
        if ($result instanceof Shipment) {
            $data = $subject->getShipment();
            if (!empty($data['sender_orders'])) {
                $result->setData('sender_orders', $data['sender_orders']);
            }
            if (!empty($data['protocol_code'])) {
                $result->setData('protocol_code', $data['protocol_code']);
            }
            if (!empty($data['pack_value'])) {
                $result->setData('pack_value', $data['pack_value']);
            }
            if (!empty($data['box_size'])) {
                $result->setData('box_size', $data['box_size']);
            }
            if (!empty($data['has_insurance'])) {
                $result->setData('has_insurance', $data['has_insurance']);
            }
        }

        return $result;
    }
}
