<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;

class BoxSize implements OptionSourceInterface
{
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => 'S', 'label' => __('S: 8 x 38 x 60 cm, max 20 kg')],
            ['value' => 'M', 'label' => __('M: 19 x 38 x 60 cm, max 20 kg')],
            ['value' => 'L', 'label' => __('L: 41 x 38 x 60 cm, max 20 kg')]
        ];
    }

    /**
     * Get label size by value
     *
     * @param string|null $value
     * @return string|null
     */
    public function getLabelByValue(?string $value): ?string
    {
        foreach ($this->toOptionArray() as $option) {
            if ($option['value'] === $value) {
                return (string) $option['label'];
            }
        }
        return null;
    }
}
