<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Model\Api;

#[\AllowDynamicProperties]
class Response
{
    private const SOFT_ERRORS_CODES = [
        '006',
        '007',
        '008'
    ];

    /** @var string */
    public string $Err = '000';

    /** @var string */
    public string $ErrDes = '';

    /**
     * Get error description
     *
     * @return string
     */
    public function getErrorDesc(): string
    {
        return $this->ErrDes;
    }

    /**
     * Get error code
     *
     * @return string
     */
    public function getErrorCode(): string
    {
        return $this->Err;
    }

    /**
     * Is error
     *
     * @return bool
     */
    public function isError(): bool
    {
        if ($this->Err == '000') {
            return false;
        }
        return !$this->isSoftError();
    }

    /**
     * Is soft error
     *
     * @return bool
     */
    public function isSoftError(): bool
    {
        if (in_array($this->Err, self::SOFT_ERRORS_CODES)) {
            return true;
        }
        return false;
    }

    /**
     * Get error description: code + message
     *
     * @return string
     */
    public function getErrorDescription(): string
    {
        if ($this->isError() || $this->isSoftError()) {
            return $this->getErrorCode() . ' - ' . $this->getErrorDesc();
        }
        return $this->ErrDes;
    }
}
