<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Model\Api;

use Macopedia\OrlenShipping\Helper\Data;

class OrderCourier
{
    /**
     * @param Client $client
     * @param Data $helper
     */
    public function __construct(
        protected readonly Client $client,
        protected readonly Data $helper
    ) {
    }

    /**
     * Call pickup to order courier
     *
     * @param array $shippingNumbers
     * @param string $readyDate
     * @param string $pickupDate
     * @return Response
     * @throws OrlenApiException
     */
    public function callPickup(array $shippingNumbers, string $readyDate, string $pickupDate): Response
    {
        $params = [
            'PartnerID' => $this->helper->getPartnerId(),
            'PartnerKey' => $this->helper->getPartnerKey(),
            'PostCode' => $this->helper->getAddressPostcode(),
            'ReadyDate' => $readyDate,
            'PickupDate' => $pickupDate,
            'City' => $this->helper->getAddressCity(),
            'Street' => $this->helper->getAddressStreet() . ' ' . $this->helper->getAddressStreetNumber(),
            'BuildingNo' => $this->helper->getAddressFlatNumber(),
            'PartnerName' => $this->helper->getAddressPartnerName(),
            'Email' => $this->helper->getAddressEmail()
        ];

        foreach ($shippingNumbers as $number) {
            $params['PackList']['string'][] = $number;
        }

        return $this->client->callPickupNew($params);
    }
}
