<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Model\Api;

use Macopedia\OrlenShipping\Helper\Data;

class GivePartnerStatus
{
    /**
     * @param Client $client
     * @param Data $helper
     */
    public function __construct(
        protected readonly Client $client,
        protected readonly Data $helper,
    ) {
    }

    /**
     * Get partner status data
     *
     * @param string|null $partnerId
     * @param string|null $partnerKey
     * @return Response
     * @throws OrlenApiException
     */
    public function getData(?string $partnerId = null, ?string $partnerKey = null): Response
    {
        return $this->client->givePartnerStatus([
            'PartnerID' => $partnerId ?: $this->helper->getPartnerId(),
            'PartnerKey' => $partnerKey ?: $this->helper->getPartnerKey()
        ]);
    }
}
