<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Model\Api;

use Macopedia\OrlenShipping\Helper\Data;

class GenerateProtocol
{
    /**
     * @param Client $client
     * @param Data $helper
     */
    public function __construct(
        protected readonly Client $client,
        protected readonly Data $helper
    ) {
    }

    /**
     * Generate protocol
     *
     * @param array $trackNumbers
     * @return Response
     * @throws OrlenApiException
     */
    public function generateProtocol(array $trackNumbers): Response
    {
        $params = [
            'PartnerID' => $this->helper->getPartnerId(),
            'PartnerKey' => $this->helper->getPartnerKey()
        ];

        foreach ($trackNumbers as $trackNumber) {
            $params['parcels']['unsignedLong'][] = $trackNumber;
        }

        return $this->client->generateProtocol($params);
    }
}
