<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Model;

class Anonymizer
{
    private const DEFAULT_MASK = '******';

    /**
     * @param array $paramsToAnonymize
     */
    public function __construct(
        private readonly array $paramsToAnonymize = []
    ) {
    }

    /**
     * Anonymize sensitive data from request
     *
     * @param string $xml
     * @return string
     */
    public function anonymizeRequest(string $xml): string
    {
        foreach ($this->paramsToAnonymize as $param) {
            $pattern = sprintf('/<[^:>]*:%s>.*?<\/[^:>]*:%s>/s', $param, $param);
            $replacement = sprintf('<ns1:%s>%s</ns1:%s>', $param, self::DEFAULT_MASK, $param);
            $xml = preg_replace($pattern, $replacement, $xml);
        }
        return $xml;
    }
}
