<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Helper\Shipping;

use Macopedia\OrlenShipping\Model\Source\BoxSize;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\UrlInterface;
use Magento\Shipping\Helper\Data as CoreShippingHelper;
use Magento\Store\Model\StoreManagerInterface;

class Data extends CoreShippingHelper
{
    /**
     * @param BoxSize               $boxSize
     * @param Context               $context
     * @param StoreManagerInterface $storeManager
     * @param UrlInterface|null     $url
     */
    public function __construct(
        private readonly BoxSize $boxSize,
        Context $context,
        StoreManagerInterface $storeManager,
        ?UrlInterface $url = null
    ) {
        parent::__construct($context, $storeManager, $url);
    }

    /**
     * Returns the box size label by value
     *
     * @param string|null $value
     * @return string|null
     */
    public function getBoxSizeByValue(?string $value): ?string
    {
        return $this->boxSize->getLabelByValue($value);
    }
}
