<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Block;

use Macopedia\OrlenShipping\Helper\Data;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Map extends Template
{
    /**
     * @param Context $context
     * @param CheckoutSession $checkoutSession
     * @param Data $helper
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        protected readonly CheckoutSession $checkoutSession,
        protected readonly Data $helper,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * Can show
     *
     * @return bool
     */
    public function canShow(): bool
    {
        if (!$this->getToken()) {
            return false;
        }
        if ($this->_scopeConfig->getValue(Data::XML_PATH_ORLEN_ACTIVE) && $this->checkoutSession->hasQuote()) {
            try {
                return $this->checkoutSession->getQuote()->getItemsCount() > 0;
            } catch (\Exception $e) {
                return false;
            }
        }

        return false;
    }

    /**
     * Get ORLEN JS widget token
     *
     * @return string|null
     */
    public function getToken(): ?string
    {
        return $this->helper->getMapWidgetToken();
    }
}
