<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Block\Adminhtml\System\Config\Field;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

class NonEditable extends Field
{
    /**
     * Set field non-editable
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element): string
    {
        $element->setReadonly(true);

        return parent::_getElementHtml($element);
    }
}
